@extends('layouts.app')

@section('content')
<div class="container">
    <h1>Seller Report</h1>

    <div class="row">
        <div class="col-md-6">
            <div class="card text-white bg-primary mb-3">
                <div class="card-body">
                    <h5 class="card-title">Total Sales</h5>
                    <p class="card-text">${{ number_format($totalSales, 2) }}</p>
                </div>
            </div>
        </div>
    </div>

    <h3>Products</h3>
    <table class="table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Status</th>
                <th>Available Quantity</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($products as $product)
                <tr>
                    <td>{{ $product->id }}</td>
                    <td>{{ $product->name }}</td>
                    <td>{{ ucfirst($product->status) }}</td>
                    <td>{{ $product->inventoryItems->sum('available_quantity') }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection